; IntelliCAD Hatch Patterns
;
; icad.pat
; Release 1.0   
;
; .............................................................................
;
; Copyright (c) 1998 by Visio Corporation.  All rights reserved.
;
; The Software is subject to the license agreement that accompanies 
; or is included with the Software, which specifies the permitted 
; and prohibited uses of the Software. Any unauthorized duplication 
; or use of Visio Corporation Software, in whole or in part, in print, 
; or in any other storage and retrieval system is prohibited.
; 
; To the maximum extent permitted by applicable law, Visio Corporation
; and its suppliers disclaim any and all warranties and conditions,
; either express or implied, including, without limitation, implied
; warranties of merchantability, fitness for a particular purpose,
; title, and non-infringement, and those arising out of usage of trade
; or course of dealing, concerning these materials.  These materials
; are provided "as is" without warranty of any kind.
; .............................................................................

;; Note: Dummy pattern description used for 'Solid fill'.
*SOLID, Solid fill
45, 0,0, 0,.125
*ANGLE, Angle steel
0, 0,0, 0,.275, .2,-.075
90, 0,0, 0,.275, .2,-.075
*ANSI31, ANSI Iron, Brick, Stone masonry
45, 0,0, 0,.125
*ANSI32, ANSI Steel
45, 0,0, 0,.375
45, .176776695,0, 0,.375
*ANSI33, ANSI Bronze, Brass, Copper
45, 0,0, 0,.25
45, .176776695,0, 0,.25, .125,-.0625
*ANSI34, ANSI Plastic, Rubber
45, 0,0, 0,.75
45, .176776695,0, 0,.75
45, .353553391,0, 0,.75
45, .530330086,0, 0,.75
*ANSI35, ANSI Fire brick, Refractory material
45, 0,0, 0,.25
45, .176776695,0, 0,.25, .3125,-.0625,0,-.0625
*ANSI36, ANSI Marble, Slate, Glass
45, 0,0, .21875,.125, .3125,-.0625,0,-.0625
*ANSI37, ANSI Lead, Zinc, Magnesium, Sound/Heat/Elec Insulation
45, 0,0, 0,.125
135, 0,0, 0,.125
*ANSI38, ANSI Aluminum
45, 0,0, 0,.125
135, 0,0, .25,.125, .3125,-.1875

;;Hatch Pattern Definition related to ISO/DIS linetypes
*ICAD_ISO02W100, dashed line
0, 0,0, 0,5, 12,-3
*ICAD_ISO03W100, dashed space line
0, 0,0, 0,5, 12,-18
*ICAD_ISO04W100, long dashed dotted line
0, 0,0, 0,5, 24,-3,.5,-3
*ICAD_ISO05W100, long dashed double dotted line
0, 0,0, 0,5, 24,-3,.5,-3,.5,-3
*ICAD_ISO06W100, long dashed triplicate dotted line
0, 0,0, 0,5, 24,-3,.5,-3,.5,-6.5
0, 0,0, 0,5, -34,.5,-3
*ICAD_ISO07W100, dotted line
0, 0,0, 0,5, .5,-3
*ICAD_ISO08W100, long dashed short dashed line
0, 0,0, 0,5, 24,-3,6,-3
*ICAD_ISO09W100, long dashed double-short-dashed line
0, 0,0, 0,5, 24,-3,6,-3,6,-3
*ICAD_ISO10W100, dashed dotted line
0, 0,0, 0,5, 12,-3,.5,-3
*ICAD_ISO11W100, double-dashed dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-3
*ICAD_ISO12W100, dashed double-dotted line
0, 0,0, 0,5, 12,-3,.5,-3,.5,-3
*ICAD_ISO13W100, double-dashed double-dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-6.5
0, 0,0, 0,5, -33.5,.5,-3
*ICAD_ISO14W100, dashed triplicate-dotted line
0, 0,0, 0,5, 12,-3,.5,-3,.5,-6.5
0, 0,0, 0,5, -22,.5,-3
*ICAD_ISO15W100, double-dashed triplicate-dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-10
0, 0,0, 0,5, -33.5,.5,-3,.5,-3
;;
*2X2BRIKC,ALTERNATE PAIRS OF BRICKS - COMPLEX
0, 0,0, 8,8, 7.625,-.375,3.625,-.375,3.625,-.375
0, 0,3.625, 8,8, 7.625,-8.375
0, 0,4, 8,8, 7.625,-8.375
0, 0,7.625, 8,8, 7.625,-.375,3.625,-.375,3.625,-.375
90, 0,0, 8,8, 3.625,-.375,3.625,-.375,7.625,-.375
90, 3.625,8, 8,8, 7.625,-8.375
90, 4,8, 8,8, 7.625,-8.375
90, 7.625,0, 8,8, 3.625,-.375,3.625,-.375,7.625,-.375
*2X2BRIKS,ALTERNATE PAIRS OF BRICKS - SIMPLEX
0, 0,0, 0,8, 1,0
0, 0,4, 8,8, 8,-8
90, 0,0, 0,8, 1,0
90, 12,0, 8,8, 8,-8

*ANCHORLK,UNI-ANCHORLOCK LOCKSTONE PAVING STONE
18.4350, -1.18585377,-.39528577, 8.75,1.25, 2.5,-10
333.4350, -2.76698979,-3.55756482, 3.53553389,1.76776696, 1.76776695,-7.07106781
63.4350, -.39528929,5.13870085, 3.53553391,1.76776695, 1.76776695,-7.07106781
108.4350, .39527871,2.76699331, 3.75,-1.25, 2.5,-10

*APPIAN2,APPIAN STONE 2 STONE PATTERN
0, 0,0, 0,6.25
90, 0,0, 0,15.75
90, 6.25,6.25, 0,15.75, 6.25,-6.25
90, 9.5,0, 0,15.75, 6.25,-6.25

*APPIANRN,APPIAN STONE RUNNING BOND
0, 0,0, 0,6.25
90, 0,0, 6.25,4.75, 6.25,-6.25

*AR-B816, 8x16 Block elevation stretcher bond
0,       0,0,      0,8
90,      0,0,      8,8,                          8,-8
*AR-B816C, 8x16 Block elevation stretcher bond with mortar joints
0,       0,0,      8,8,                         15.625,-.375
0,      -8,.375,   8,8,                         15.625,-.375
90,      0,0,      8,8,                        -8.375,7.625
90,     -0.375,0,  8,8,                        -8.375,7.625
*AR-B88, 8x8 Block elevation stretcher bond
0,       0,0,      0,8
90,      0,0,      8,4,                          8,-8
*AR-BRELM, Standard brick elevation english bond with mortar joints
0,      0,0,       0,5.334,                      7.625,-.375
0,      0,2.25,    0,5.334,                      7.625,-.375
0,      2,2.667,   0,5.334,                      3.625,-.375
0,      2,4.917,   0,5.334,                      3.625,-.375
90,     0,0,       0,8,                          2.25,-3.084
90,    -0.375,0,   0,8,                          2.25,-3.084
90,     2,2.667,   0,4,                          2.25,-3.084
90,     1.625,2.667,  0,4,                       2.25,-3.084
*AR-BRSTD, Standard brick elevation stretcher bond
0,       0,0,      0,2.667
90,      0,0,      2.667,4,                      2.667,-2.667
*AR-CONC, Random dot and stone pattern
50,      0,0,      4.12975034,-5.89789472,       0.75,-8.25
355,     0,0,     -2.03781207,7.37236840,        0.60,-6.6
100.4514, 0.5977168,-0.0522934, 5.7305871,-6.9397673, 0.6374019,-7.01142112
46.1842, 0,2,      6.19462551,-8.84684208,       1.125,-12.375
96.6356, 0.88936745,1.86206693, 8.59588071,-10.40965104, 0.95610288,-10.51713
351.1842, 0,2,     7.74328189,11.0585526,        0.9,-9.9
21,      1,1.5,    4.12975034,-5.89789472,       0.75,-8.25
326,     1,1.5,   -2.03781207,7.37236840,        0.60,-6.6
71.4514, 1.49742233,1.16448394, 5.7305871,-6.9397673, 0.6374019,-7.01142112
37.5,    0,0,      2.123,2.567,                  0,-6.52,0,-6.7,0,-6.625
7.5,     0,0,      3.123,3.567,                  0,-3.82,0,-6.37,0,-2.525
-32.5,  -2.23,0,   4.6234,2.678,                 0,-2.5,0,-7.8,0,-10.35
-42.5,  -3.23,0,   3.6234,4.678,                 0,-3.25,0,-5.18,0,-7.35
*AR-HBONE, Standard brick herringbone pattern @ 45 degrees
45,      0,0,      4,4,                          12,-4
135,     2.828427125,2.828427125,  4,-4,         12,-4
*AR-PARQ1, 2x12 Parquet flooring: pattern of 12x12
90,      0,0,      12,12,                        12,-12
90,      2,0,      12,12,                        12,-12
90,      4,0,      12,12,                        12,-12
90,      6,0,      12,12,                        12,-12
90,      8,0,      12,12,                        12,-12
90,     10,0,      12,12,                        12,-12
90,     12,0,      12,12,                        12,-12
0,      0,12,      12,-12,                       12,-12
0,      0,14,      12,-12,                       12,-12
0,      0,16,      12,-12,                       12,-12
0,      0,18,      12,-12,                       12,-12
0,      0,20,      12,-12,                       12,-12
0,      0,22,      12,-12,                       12,-12
0,      0,24,      12,-12,                       12,-12
*AR-RROOF, Roof shingle texture
0, 0,0, 2.2,1, 15,-2,5,-1
0, 1.33,0.5, -1,1.33, 3,-0.33,6,-0.75
0, 0.5,0.85, 5.2,0.67, 8,-1.4,4,-1
*AR-RSHKE, Roof wood shake texture
0,       0,0,      25.5,12,                        6,-5,7,-3,9,-4
0,       6,.5,     25.5,12,                        5,-19,4,-6
0,       18,-.75,  25.5,12,                        3,-31
90,      0,0,      12,8.5,                       11.5,-36.5
90,      6,0,      12,8.5,                       11.25,-36.75
90,      11,0,     12,8.5,                       10.5,-37.5
90,      18,-0.75, 12,8.5,                       11.5,-36.5
90,      21,-0.75, 12,8.5,                       11.5,-36.5
90,      30,0,     12,8.5,                       11,-37
*AR-SAND, Random dot pattern
37.5,   0,0,       1.123,1.567,                  0,-1.52,0,-1.7,0,-1.625
7.5,    0,0,       2.123,2.567,                  0,-.82,0,-1.37,0,-.525
-32.5, -1.23,0,    2.6234,1.678,                 0,-.5,0,-1.8,0,-2.35
-42.5, -1.23,0,    1.6234,2.678,                 0,-.25,0,-1.18,0,-1.35
*ASPHALT,ASPHALT
0,0.468381,0.182977,0,1,0,-1
0,-0.451355,0.317935,0,1,0,-1
0,-0.456354,-0.179412,0,1,0,-1
0,0.125979,-0.201905,0,1,0,-1
0,0.343417,-0.209402,0,1,0,-1
0,0.046002,0.440397,0,1,0,-1
0,0.413397,0.465389,0,1,0,-1
0,-0.098956,0.215467,0,1,0,-1
0,-0.021478,0.015528,0,1,0,-1
0,-0.201427,-0.071945,0,1,0,-1
0,-0.293900,0.053017,0,1,0,-1
0,0.313426,0.038021,0,1,0,-1
0,-0.008982,0.310437,0,1,0,-1
0,-0.203926,0.450394,0,1,0,-1
0,0.250944,0.297941,0,1,0,-1
0,-0.378876,0.195473,0,1,0,-1
0,0.011012,-0.064447,0,1,0,-1
0,0.258442,-0.441831,0,1,0,-1
0,-0.366380,-0.429334,0,1,0,-1
0,-0.106454,-0.331865,0,1,0,-1
0,-0.313895,-0.314370,0,1,0,-1
0.000000,-0.500000,0.500000,0.000000,1.000000,1.000000,0.000000
0.000000,-0.500000,0.375000,0.000000,1.000000,1.000000,0.000000
0.000000,-0.500000,0.250000,0.000000,1.000000,1.000000,0.000000
0.000000,-0.500000,0.125000,0.000000,1.000000,1.000000,0.000000
0.000000,-0.500000,0.000000,0.000000,1.000000,1.000000,0.000000
0.000000,-0.500000,-0.125000,0.000000,1.000000,1.000000,0.000000
0.000000,-0.500000,-0.250000,0.000000,1.000000,1.000000,0.000000
0.000000,-0.500000,-0.375000,0.000000,1.000000,1.000000,0.000000

*BOARD,BOARD PLANKING
0, 0,.4, 0,1
90, 0,.4, 4,4, 1,-14
90, 6,2.4, 4,4, 1,-14

*BOARDW,WIDE BOARDS
0, 0,.4, 0,2
90, 0,.4, 4,4, 2,-14
90, 8,2.4, 4,4, 2,-14

*BOARDWN,WIDE BOARDS WITH NAILS
0, 0,.4, 0,2
90, 0,.4, 4,4, 2,-14
90, .4,1, 4,4, 0,-.8,0,-15.2
90, 15.6,1, 4,4, 0,-.8,0,-15.2
90, 8,2.4, 4,4, 2,-14
90, 7.6,3, 4,4, 0,-.8,0,-15.2
90, 8.4,3, 4,4, 0,-.8,0,-15.2

*BOX, Box steel
90, 0,0, 0,1
90, .25,0, 0,1
0, 0,0, 0,1, -.25,.25
0, 0,.25, 0,1, -.25,.25
0, 0,.5, 0,1, .25,-.25
0, 0,.75, 0,1, .25,-.25
90, .5,0, 0,1, .25,-.25
90, .75,0, 0,1, .25,-.25
*BRASS, Brass material
0, 0,0, 0,.25
0, 0,.125, 0,.25, .125,-.0625
*BRICK, Brick or masonry-type surface
0, 0,0, 0,.25
90, 0,0, 0,.5, .25,-.25
90, .25,0, 0,.5, -.25,.25
*BRSTONE, Brick and stone
0, 0,0, 0,.33
90, .9,0,  .33,.5,    .33,-.33
90, .8,0,  .33,.5,    .33,-.33  
0, .9,.055,  .5,.33,  -.9, .1
0, .9,.11,  .5,.33,  -.9, .1
0, .9,.165,  .5,.33,  -.9, .1
0, .9,.22,  .5,.33,  -.9, .1
0, .9,.275,  .5,.33,  -.9, .1

*CHECKERED,CHECKERED PLATE PATTERN
0, 0,0, 1,1, 1,-1
90, .5,.5, 1,1, 1,-1

*CONC,CONCRETE
0, 0.950,0.640, 0,1, 0,-1
0, 0.960,0.290, 0,1, 0,-1
0, 0.990,0.830, 0,1, 0,-1
338.1986, 0.470,0.520, 3.156821,0.185695, 0.107703,-5.277462
216.8699, 0.570,0.480, -3.600000,0.200000, 0.050000,-4.950000
130.6013, 0.530,0.450, -7.809496,0.108465, 0.092195,-9.127349
206.5651, 0.200,0.330, 1.341641,0.447214, 0.022361,-2.213707
326.3099, 0.180,0.320, 2.218801,0.277350, 0.036056,-3.569496
108.4349, 0.210,0.300, 2.213594,0.316228, 0.031623,-3.130655
225.0000, 0.840,0.230, 0.707107,0.707107, 0.042426,-1.371787
0.0000, 0.810,0.200, 1.000,1.000, 0.060000,-0.940
135.0000, 0.870,0.200, 0.707107,0.707107, 0.042426,-1.371787
251.5651, 0.720,0.870, -2.213594,0.316228, 0.031623,-3.130655
0.0000, 0.710,0.840, 1.000,1.000, 0.050000,-0.950
143.1301, 0.760,0.840, 3.600000,0.200000, 0.050000,-4.950000
213.6901, 0.190,0.880, -2.218801,0.277350, 0.036056,-3.569496
341.5651, 0.160,0.860, -2.213594,0.316228, 0.063246,-3.099032
126.8699, 0.220,0.840, -3.600000,0.200000, 0.050000,-4.950000
0, 0.480,0.840, 0,1, 0,-1
0, 0.210,0.580, 0,1, 0,-1
0, 0.490,0.210, 0,1, 0,-1
0, 0.760,0.520, 0,1, 0,-1
0, 0.470,0.690, 0,1, 0,-1
0, 0.250,0.720, 0,1, 0,-1
0, 0.340,0.660, 0,1, 0,-1
0, 0.300,0.420, 0,1, 0,-1
0, 0.060,0.460, 0,1, 0,-1
0, 0.070,0.690, 0,1, 0,-1
0, 0.040,0.910, 0,1, 0,-1
0, 0.350,0.950, 0,1, 0,-1
0, 0.570,0.990, 0,1, 0,-1
0, 0.920,0.950, 0,1, 0,-1
0, 0.680,0.640, 0,1, 0,-1
0, 0.580,0.820, 0,1, 0,-1
0, 0.660,0.340, 0,1, 0,-1
0, 0.360,0.290, 0,1, 0,-1
0, 0.660,0.070, 0,1, 0,-1
0, 0.330,0.130, 0,1, 0,-1
0, 0.010,0.100, 0,1, 0,-1
0, 0.130,0.050, 0,1, 0,-1
0, 0.140,0.190, 0,1, 0,-1
0, 0.810,0.030, 0,1, 0,-1
0, 0.930,0.440, 0,1, 0,-1
0, 0.880,0.740, 0,1, 0,-1
0, 0.420,0.020, 0,1, 0,-1

*CONCRE,CONCRETE POCHE BY VISIO CORPORATION
0,0,0,1.0,1.0,0.125,-0.875
90,0,0,1.0,1.0,0.125,-0.875
135,0.125,0,0.70710678,0.70710678,0.17677670,-1.2374369
0,0.125,0.5625,1.0,1.0,0.125,-0.875
45,0.1875,0.5,0.70710678,0.70710678,0.0883883,-1.3258252
135,0.1875,0.5,0.70710678,0.70710678,0.0883883,-1.3258252
0,0.5,0.8125,1.0,1.0,0.1767767,-0.8232233
45,0.5,0.8125,0.70710678,0.70710678,0.125,-1.2892136
135,0.6767767,0.8125,0.70710678,0.70710678,0.125,-1.2892136
90,0.6875,0.25,1.0,1.0,0.125,-0.875
45,0.6875,0.25,0.70710678,0.70710678,0.0883883,-1.3258252
135,0.75,0.3125,0.70710678,0.70710678,0.0883883,-1.3258252
0,0.125,0.25,1.0,1.0,0.0625,-0.8375
0,0.875,0.5,1.0,1.0,0.0625,-0.8375
90,0.5625,0.625,1.0,1.0,0.0625,-0.8375
135,0.6875,0.0625,0.70710678,0.70710678,0.0883883,-1.3258252
135,0.25,0.75,0.70710678,0.70710678,0.0883883,-1.3258252
45,0.46875,0.328125,0.70710678,0.70710678,0.0883883,-1.3258252
90,0.34375,0.125,1.0,1.0,0.015625,-0.984375
90,0.390625,0.546875,1.0,1.0,0.015625,-0.984375
90,0.859375,0.71875,1.0,1.0,0.015625,-0.984375
90,0.875,0.1875,1.0,1.0,0.015625,-0.984375

*CLAY, Clay material
0, 0,0, 0,.1875
0, 0,.03125, 0,.1875
0, 0,.0625, 0,.1875
0, 0,.125, 0,.1875, .1875,-.125
*CORK, Cork material
0, 0,0, 0,.125
135, .0625,-.0625, 0,.35355339, .176776696,-.176776696
135, .09375,-.0625, 0,.35355339, .176776696,-.176776696
135, .125,-.0625, 0,.35355339, .176776696,-.176776696
*CROSS, A series of crosses
0, 0,0, .25,.25, .125,-.375
90, .0625,-.0625, .25,.25, .125,-.375

*CTYSQ6RN,CITY SQUARE RUNNER 6"X6" PAVING STONE
0, 0,0, 0,6
90, 0,0, 6,3, 6,-6

*CTYSQ6ST,CITY SQUARE 6"X6" STACKED BOND PATTERN
0, 0,0, 0,6
90, 0,0, 0,6

*CTYSQMK1,CITY SQUARE MARK I W/. HOLLND II HALVES
0, 2.8284,0, 12,12, 18.3431,-5.6569
90, 0,2.8284, 12,12, 18.3431,-5.6569
0, 0,12, 0,24
90, 12,0, 0,24
45, -2.8284,0, 16.9706,16.9706, 4,-29.9412
135, 2.8284,0, 16.9706,16.9706, 4,-29.9412
45, 0,-2.8284, 16.9706,16.9706, 4,-29.9412
135, 0,-2.8284, 16.9706,16.9706, 4,-29.9412

*CTYSQMK2,CITY SQUARE MARK II W/. HOLLND II HALVES
0, 2.8284,0, 12,12, 18.3431,-5.6569
90, 0,2.8284, 12,12, 18.3431,-5.6569
45, 9.1716,12, 0,16.9706, 4,-12.9706
315, 9.1716,12, 0,16.9706, 4,-12.9706
45, 12,9.1716, 0,16.9706, 4,-12.9706
315, 12,14.8284, 0,16.9706, 4,-12.9706

*CTYSQRN,CITY SQUARE 6"X6" RUNNER
0, 0,0, 0,12
90, 0,0, 12,6, 12,-12

*CTYSQST,CITY SQUARE 12"X12" STACKED BOND PATTERN
0, 0,0, 0,12
90, 0,0, 0,12

*DASH, Dashed lines
0, 0,0, .125,.125, .125,-.125
*DOLMIT, Geological rock layering
0, 0,0, 0,.25
45, 0,0, 0,.70710678, .35355339,-.70710768
*DOTS, A series of dots
0, 0,0, .03125,.0625, 0,-.0625

*DBLHLNRN,DOUBLE HOLLAND RUNNER PAVING STONE
0, 0,0, 0,8
90, 0,0, 8,4, 8,-8

*DBLHLNST,DOUBLE HOLLAND STACKED BOND PAVER
0, 0,0, 0,8
90, 0,0, 0,8

*DELTA,DELTA TYPE CONC. PAVERS
30, 0,0, 3,5.19615242, 2,-4
30, -1.73205081,3, 3,5.19615242, 2,-4
90, 0,4, 3,5.19615242, 2,-4
90, 3.46410162,4, 3,5.19615242, 2,-4
150, 0,0, 3,5.19615242, 2,-4
150, -1.73205081,3, 3,5.19615242, 2,-4

*DIAMONDS,DIAMONDS
60, 0,0, 0,.125
120, 0,0, 0,.125

*EARTH, Earth or ground (subterranean)
0, 0,0, .25,.25, .25,-.25
0, 0,.09375, .25,.25, .25,-.25
0, 0,.1875, .25,.25, .25,-.25
90, .03125,.21875, .25,.25, .25,-.25
90, .125,.21875, .25,.25, .25,-.25
90, .21875,.21875, .25,.25, .25,-.25

*EARTH2,COMPLEX EARTH
180.0000, 0.480,0.480, 1.000,1.000, 0.450000,-0.550
180.0000, 0.480,0.030, 1.000,1.000, 0.450000,-0.550
180.0000, 0.480,0.140, 1.000,1.000, 0.460000,-0.540
180.0000, 0.480,0.250, 1.000,1.000, 0.460000,-0.540
180.0000, 0.480,0.360, 1.000,1.000, 0.460000,-0.540
180.0000, 0.980,0.860, 1.000,1.000, 0.450000,-0.550
180.0000, 0.980,0.750, 1.000,1.000, 0.450000,-0.550
180.0000, 0.980,0.640, 1.000,1.000, 0.450000,-0.550
180.0000, 0.980,0.530, 1.000,1.000, 0.450000,-0.550
180.0000, 0.980,0.980, 1.000,1.000, 0.450000,-0.550
270.0000, 0.020,0.980, 1.000,1.000, 0.450000,-0.550
270.0000, 0.480,0.980, 1.000,1.000, 0.450000,-0.550
270.0000, 0.360,0.980, 1.000,1.000, 0.450000,-0.550
270.0000, 0.250,0.980, 1.000,1.000, 0.450000,-0.550
270.0000, 0.140,0.980, 1.000,1.000, 0.450000,-0.550
270.0000, 0.640,0.480, 1.000,1.000, 0.460000,-0.540
270.0000, 0.750,0.480, 1.000,1.000, 0.460000,-0.540
270.0000, 0.860,0.480, 1.000,1.000, 0.460000,-0.540
270.0000, 0.980,0.480, 1.000,1.000, 0.450000,-0.550
270.0000, 0.530,0.480, 1.000,1.000, 0.450000,-0.550

*EGYPT,EGYPTIAN PATTERN
0,0,0,0,1,0.2,-0.2,0.6
0,0,0.2,0,1,-0.6,0.4
0,0,0.4,0,1,-0.6,0.2,-0.2
0,0,0.6,0,1,-0.4,0.4,-0.2
0,0,0.8,0,1,-0.2,0.8
90,0.2,0,0,1,0.8,-0.2
90,0.4,0,0,1,0.6,-0.4
90,0.6,0,0,1,-0.2,0.2,-0.6
90,0.8,0,0,1,-0.4,0.2,-0.4
90,1.0,0,0,1,-0.2,0.6,-0.2

*ESCHER, Escher pattern
60, 0,0, -.6,1.039230484, 1.1,-.1
180, 0,0, -.6,1.039230484, 1.1,-.1
300, 0,0, .6,1.039230484, 1.1,-.1
60, .1,0, -.6,1.039230484, .2,-1
300, .1,0, .6,1.039230484, .2,-1
60, -.05,.08660254, -.6,1.039230484, .2,-1
180, -.05,.08660254, -.6,1.039230484, .2,-1
300, -.05,-.08660254, .6,1.039230484, .2,-1
180, -.05,-.08660254, -.6,1.039230484, .2,-1
60, -.4,0, -.6,1.039230484, .2,-1
300, -.4,0, .6,1.039230484, .2,-1
60, .2,-.346410161, -.6,1.039230484, .2,-1
180, .2,-.346410161, -.6,1.039230484, .2,-1
300, .2,.346410161, .6,1.039230484, .2,-1
180, .2,.346410161, -.6,1.039230484, .2,-1
0, .2,.173205081, -.6,1.039230484, .7,-.5
0, .2,-.173205081, -.6,1.039230484, .7,-.5
120, .05,.259807621, .6,1.039230484, .7,-.5
120, -.25,.08660254, .6,1.039230484, .7,-.5
240, -.25,-.08660254, .6,1.039230484, .7,-.5
240, .05,-.259807621, .6,1.039230484, .7,-.5

*FBBRICKC,FLEMMISH BOND BRICK - COMPLEX
0, 0,0, 6,2.666666666, 7.625,-4.375
0, 8,0, 6,2.666666666, 3.625,-8.375
0, 0,2.291666666, 6,2.666666666, 7.625,-4.375
0, 8,2.291666666, 6,2.666666666, 3.625,-8.375
90, 0,0, 2.666666666,6, 2.291666666,-3.041666666
90, 7.625,0, 2.666666666,6, 2.291666666,-3.041666666
90, 8,0, 2.666666666,6, 2.291666666,-3.041666666
90, 11.625,0, 2.666666666,6, 2.291666666,-3.041666666

*FBBRICKS,FLEMMISH BOND BRICK - SIMPLEX
0, 0,0, 0,2.666666666
90, 0,0, 2.666666666,6, 2.666666666,-2.666666666
90, 4,0, 2.666666666,6, 2.666666666,-2.666666666

*FINETTA,FINETTA STONE HATCH PATTERN
0, -1,0, 3,3, 2,-4
0, 2,1, 3,3, 2,-4
90, 0,0, 3,3, 4,-2
45, 1,0, 0,4.24264069, 1.41421356,-2.82842712
135, -1,0, 0,4.24264069, 1.41421356,-2.82842712

*FLEX, Flexible material
0, 0,0, 0,.25, .25,-.25
45, .25,0, .176776695,.176776695, .0625,-.228553391,.0625,-.353553391

*GLASS,GLASS REFLECTION
236.3099, 0.600,0.700, 2.218801,0.277350, 0.360555,-3.244996
236.3099, 0.620,0.640, 2.218801,0.277350, 0.216333,-3.389218
236.3099, 0.500,0.640, 2.218801,0.277350, 0.216333,-3.389218

*GLB,GLUE LAMINATION PATTERN BY VISIO CORPORATION
0, 0,0, 0,1.0
315, 0,0, 0.707106781,0.707106781, 1.414213563, -1.414213563
45, 0,0, 0.707106781,-0.707106781, 1.414213563, -1.414213563

*GRASS, Grass area
90, 0,0, .707106781,.707106781, .1875,-1.226713563
45, 0,0, 0,1, .1875,-.8125
135, 0,0, 0,1, .1875,-.8125
*GRATE, Grated area
0, 0,0, 0,.03125
90, 0,0, 0,.125
*GRAVEL,Gravel pattern
228.0128, 0.720,1.000, 12.041365,0.074329, 0.134536,-13.319088
184.9697, 0.630,0.900, -12.041517,0.043315, 0.230868,-22.855925
132.5104, 0.400,0.880, -14.865942,0.061430, 0.162788,-16.116032
267.2737, 0.010,0.630, -20.024928,0.047565, 0.210238,-20.813558
292.8337, 0.000,0.420, -12.999910,0.048507, 0.206155,-20.409373
357.2737, 0.080,0.230, -20.024928,0.047565, 0.210238,-20.813558
37.6942, 0.290,0.220, -16.401180,0.035968, 0.278029,-27.524849
72.2553, 0.510,0.390, 23.086761,0.038097, 0.262488,-25.986321
121.4296, 0.590,0.640, 15.264264,0.047405, 0.210950,-20.884073
175.2364, 0.480,0.820, -11.045049,0.083045, 0.240832,-11.800763
222.3974, 0.240,0.840, 16.278789,0.032108, 0.311448,-30.833375
138.8141, 1.000,0.620, 9.219065,0.094072, 0.106301,-10.523844
171.4692, 0.920,0.690, -13.152853,0.049447, 0.202237,-20.021511
225.0000, 0.720,0.720, 0.707107,0.707107, 0.141421,-1.272792
203.1986, 0.650,0.840, -5.383564,0.131306, 0.076158,-7.539615
291.8014, 0.580,0.810, -3.156821,0.185695, 0.107703,-5.277462
30.9638, 0.620,0.710, 3.601470,0.171499, 0.174929,-5.656023
161.5651, 0.770,0.800, -2.213594,0.316228, 0.126491,-3.035787
16.3895, 0.000,0.810, 10.440154,0.056433, 0.177200,-17.542845
70.3462, 0.170,0.860, -11.704507,0.067267, 0.148661,-14.717408
293.1986, 0.770,1.000, -5.383564,0.131306, 0.152315,-7.463458
343.6105, 0.830,0.860, -10.440154,0.056433, 0.177200,-17.542845
339.4440, 0.000,0.190, -5.383893,0.117041, 0.170880,-8.373124
294.7751, 0.160,0.130, -12.082844,0.069843, 0.143178,-14.174643
66.8014, 0.780,0.000, 5.383564,0.131306, 0.152315,-7.463458
17.3540, 0.840,0.140, -13.601340,0.059655, 0.167631,-16.595424
69.4440, 0.290,0.000, -5.383893,0.117041, 0.085440,-8.458564
101.3099, 0.720,0.000, 4.118439,0.196116, 0.050990,-5.048029
165.9638, 0.710,0.050, -3.152963,0.242536, 0.206155,-3.916950
186.0090, 0.510,0.100, -10.049739,0.052342, 0.191050,-18.913923
303.6901, 0.620,0.620, -2.218801,0.277350, 0.144222,-3.461329
353.1572, 0.700,0.500, 17.117197,0.039715, 0.251794,-24.927563
60.9454, 0.950,0.470, -8.061673,0.097129, 0.102956,-10.192674
90.0000, 1.000,0.560, 1.000,1.000, 0.060000,-0.940
120.2564, 0.490,0.130, -8.061936,0.071982, 0.138924,-13.753520
48.0128, 0.420,0.250, 12.041365,0.074329, 0.269072,-13.184552
0.0000, 0.600,0.450, 1.000,1.000, 0.260000,-0.740
325.3048, 0.860,0.450, -12.206392,0.063246, 0.158114,-15.653274
254.0546, 0.990,0.360, 4.120817,0.137361, 0.145602,-7.134508
207.6460, 0.950,0.220, 21.470869,0.042182, 0.237065,-23.469474
175.4261, 0.740,0.110, 13.038344,0.039873, 0.250799,-24.829074

*GROUT,GROUT MATERIAL BY VISIO CORPORATION
0, 4,2, 1,8, 1,-7
0, 5,5, 0,8, 0,-8
0, 2,2, 3,8, 0,-8
0, 2,8, 8,8, 2,-14
0, 8,3, 0,8, 0,-8
0, 6,2, 2,8, 0,-8
0, 7,3, 0,8, 0,-8
0, 3,8, 0,8, 0,-8

*HEX, Hexagons
0, 0,0, 0,.216506351, .125,-.25
120, 0,0, 0,.216506351, .125,-.25
60, .125,0, 0,.216506351, .125,-.25

*HLNBSK,HOLLAND STONE BASKETWEAVE PATTERN
0, 0,0, 0,8
0, 0,4, 0,8, 8,-4
90, 0,0, 0,12
90, 8,0, 0,12

*HLNHER,HOLLAND STONE HERINGBONE PATTERN
0, 0,0, 4,4, 12,-4
90, 4,0, -4,4,  12,-4

*HLNIST,HOLLAND STONE STACK BOND
0, 0,0, 0,4
90, 0,0, 0,4

*HLNPARQ,HOLLAND STONE PARQUET PATTERN
0, 0,0, 0,8
0, 8,4, 8,8, 8,-8
90, 0,0, 0,8
90, 4,0, 8,8, 8,-8

*HLNRN,HOLLAND STONE PARQUET PATTERN
0, 0,0, 0,4
90, 0,0, 4,4, 4,-4

*HLNST,HOLLAND STONE STACK BOND
0, 0,0, 0,4
90, 0,0, 0,8

*HONEY, Honeycomb pattern
0, 0,0, .1875,.108253175, .125,-.25
120, 0,0, .1875,.108253175, .125,-.25
60, 0,0, .1875,.108253175, -.25,.125
*HOUND, Houndstooth check
0, 0,0, .25,.0625, 1,-.5
90, 0,0, -.25,.0625, 1,-.5
*INSUL, Insulation material
0, 0,0, 0,.375
0, 0,.125, 0,.375, .125,-.125
0, 0,.25, 0,.375, .125,-.125

*LINE, Parallel horizontal lines
0, 0,0, 0,.125

*MBLOCKC,RUNNING BOND MASONRY - COMPLEX
0, 0,0, 8,8, 15.625,-.375
90, 0,0, 8,8, 7.625,-8.375
0, 0,7.625, 8,8, 15.625,-.375
90, 15.625,0, 8,8, 7.625,-8.375

*MBLOCKS,RUNNING BOND MASONRY - SIMPLE
0, 0,0, 0,8
90, 0,0, 8,8, 8,-8

*MRBLOCKC,RUNNING BOND RIBBED MASONRY - COMPLEX
0, 0,0, 8,8, 15.625,-.375
90, 0,0, 8,8, 7.625,-8.375
0, 0,7.625, 8,8, 15.625,-.375
90, 15.625,0, 8,8, 7.625,-8.375
90, .8125,.5, 0,16, 6.625,-9.375
90, 2.8125,.5, 0,16, 6.625,-9.375
90, 4.8125,.5, 0,16, 6.625,-9.375
90, 6.8125,.5, 0,16, 6.625,-9.375
90, 8.8125,.5, 0,16, 6.625,-9.375
90, 10.8125,.5, 0,16, 6.625,-9.375
90, 12.8125,.5, 0,16, 6.625,-9.375
90, 14.8125,.5, 0,16, 6.625,-9.375
90, 8.8125,8.5, 0,16, 6.625,-9.375
90, 10.8125,8.5, 0,16, 6.625,-9.375
90, 12.8125,8.5, 0,16, 6.625,-9.375
90, 14.8125,8.5, 0,16, 6.625,-9.375
90, 16.8125,8.5, 0,16, 6.625,-9.375
90, 18.8125,8.5, 0,16, 6.625,-9.375
90, 20.8125,8.5, 0,16, 6.625,-9.375
90, 22.8125,8.5, 0,16, 6.625,-9.375

*MRBLOCKS,RUNNING BOND RIBBED MASONRY - SIMPLE
0, 0,0, 0,8
90, 0,0, 8,8, 8,-8
90, 1,.5, 0,16, 7,-9
90, 3,.5, 0,16, 7,-9
90, 5,.5, 0,16, 7,-9
90, 7,.5, 0,16, 7,-9
90, 9,.5, 0,16, 7,-9
90, 11,.5, 0,16, 7,-9
90, 13,.5, 0,16, 7,-9
90, 15,.5, 0,16, 7,-9
90, 9,8.5, 0,16, 7,-9
90, 11,8.5, 0,16, 7,-9
90, 13,8.5, 0,16, 7,-9
90, 15,8.5, 0,16, 7,-9
90, 17,8.5, 0,16, 7,-9
90, 19,8.5, 0,16, 7,-9
90, 21,8.5, 0,16, 7,-9
90, 23,8.5, 0,16, 7,-9

*MSBLOCKC,RUNNING BOND SPLIT FACE MASONRY - COMPLEX
0, 0,0, 8,8, 15.625,-.375
90, 0,0, 8,8, 7.625,-8.375
0, 0,7.625, 8,8, 15.625,-.375
90, 15.625,0, 8,8, 7.625,-8.375
90, 2,.75, 16,16, 1,-31
135, 2,1.75, 22.627417,22.627417, .3535534,-22.273864
90, 1.75,2, 16,16, 1.5,-30.5
90, 8,3, 16,16, 1.5,-30.5
135, 8,4.5, 22.627417,22.627417, .3535534,-22.273864
90, 7.75,4.75, 16,16, 1,-31
90, 14,2.5, 16,16, 1.5,-30.5
135, 14,4, 22.627417,22.627417, .7071068,-21.92031
90, 13.5,4.5, 16,16, .5,-31.5
90, 18,.75, 16,16, 1,-31
135, 18,1.75, 22.627417,22.627417, .3535534,-22.273864
90, 17.75,2, 16,16, 1.5,-30.5
90, 24,3, 16,16, 1.5,-30.5
135, 24,4.5, 22.627417,22.627417, .3535534,-22.273864
90, 23.75,4.75, 16,16, 1,-31
90, 30,2.5, 16,16, 1.5,-30.5
135, 30,4, 22.627417,22.627417, .7071068,-21.92031
90, 29.5,4.5, 16,16, .5,-31.5
90, 10,8.75, 16,16, 1,-31
135, 10,9.75, 22.627417,22.627417, .3535534,-22.273864
90, 9.75,10, 16,16, 1.5,-30.5
90, 16,11, 16,16, 1.5,-30.5
135, 16,12.5, 22.627417,22.627417, .3535534,-22.273864
90, 15.75,12.75, 16,16, 1,-31
90, 22,10.5, 16,16, 1.5,-30.5
135, 22,12, 22.627417,22.627417, .7071068,-21.92031
90, 21.5,12.5, 16,16, .5,-31.5
90, 26,8.75, 16,16, 1,-31
135, 26,9.75, 22.627417,22.627417, .3535534,-22.273864
90, 25.75,10, 16,16, 1.5,-30.5
90, 32,11, 16,16, 1.5,-30.5
135, 32,12.5, 22.627417,22.627417, .3535534,-22.273864
90, 31.75,12.75, 16,16, 1,-31
90, 38,10.5, 16,16, 1.5,-30.5
135, 38,12, 22.627417,22.627417, .7071068,-21.92031
90, 37.5,12.5, 16,16, .5,-31.5

*MSBLOCKS,RUNNING BOND SPLIT FACE MASONRY - SIMPLE
0, 0,0, 0,8
90, 0,0, 8,8, 8,-8
90, 2,.75, 16,16, 1,-31
135, 2,1.75, 22.627417,22.627417, .3535534,-22.273864
90, 1.75,2, 16,16, 1.5,-30.5
90, 8,3, 16,16, 1.5,-30.5
135, 8,4.5, 22.627417,22.627417, .3535534,-22.273864
90, 7.75,4.75, 16,16, 1,-31
90, 14,2.5, 16,16, 1.5,-30.5
135, 14,4, 22.627417,22.627417, .7071068,-21.92031
90, 13.5,4.5, 16,16, .5,-31.5
90, 18,.75, 16,16, 1,-31
135, 18,1.75, 22.627417,22.627417, .3535534,-22.273864
90, 17.75,2, 16,16, 1.5,-30.5
90, 24,3, 16,16, 1.5,-30.5
135, 24,4.5, 22.627417,22.627417, .3535534,-22.273864
90, 23.75,4.75, 16,16, 1,-31
90, 30,2.5, 16,16, 1.5,-30.5
135, 30,4, 22.627417,22.627417, .7071068,-21.92031
90, 29.5,4.5, 16,16, .5,-31.5
90, 10,8.75, 16,16, 1,-31
135, 10,9.75, 22.627417,22.627417, .3535534,-22.273864
90, 9.75,10, 16,16, 1.5,-30.5
90, 16,11, 16,16, 1.5,-30.5
135, 16,12.5, 22.627417,22.627417, .3535534,-22.273864
90, 15.75,12.75, 16,16, 1,-31
90, 22,10.5, 16,16, 1.5,-30.5
135, 22,12, 22.627417,22.627417, .7071068,-21.92031
90, 21.5,12.5, 16,16, .5,-31.5
90, 26,8.75, 16,16, 1,-31
135, 26,9.75, 22.627417,22.627417, .3535534,-22.273864
90, 25.75,10, 16,16, 1.5,-30.5
90, 32,11, 16,16, 1.5,-30.5
135, 32,12.5, 22.627417,22.627417, .3535534,-22.273864
90, 31.75,12.75, 16,16, 1,-31
90, 38,10.5, 16,16, 1.5,-30.5
135, 38,12, 22.627417,22.627417, .7071068,-21.92031
90, 37.5,12.5, 16,16, .5,-31.5

*MUDST, Mud and sand
0, 0,0, .5,.25, .25,-.25,0,-.25,0,-.25
*NET, Horizontal / vertical grid
0, 0,0, 0,.125
90, 0,0, 0,.125
*NET3, Network pattern 0-60-120
0, 0,0, 0,.125
60, 0,0, 0,.125
120, 0,0, 0,.125

*OCTAGON,OCTAGON
315.0000, 0.000,0.290, 0.707107,0.707107, 0.410122,-1.004092
0.0000, 0.290,0.000, 1.000,1.000, 0.420000,-0.580
45.0000, 0.710,0.000, 0.707107,0.707107, 0.410122,-1.004092
135.0000, 1.000,0.710, 0.707107,0.707107, 0.410122,-1.004092
225.0000, 0.290,1.000, 0.707107,0.707107, 0.410122,-1.004092
270.0000, 0.000,0.710, 1.000,1.000, 0.420000,-0.580

*PLAST, Plastic material
0, 0,0, 0,.25
0, 0,.03125, 0,.25
0, 0,.0625, 0,.25
*PLASTI, Plastic material
0, 0,0, 0,.25
0, 0,.03125, 0,.25
0, 0,.0625, 0,.25
0, 0,.15625, 0,.25

*PLUS,PLUS SIGNS
0,0,0.25,0,1,0.5,-0.5
90,0.25,0,0,1,0.5,-0.5

*RBBRICKC,RUNNING BOND BRICK - COMPLEX
0, 0,0, 4,2.666666666, 7.625,-.375
90, 0,0, 2.666666666,4, 2.291666666,-3.041666666
0, 0,2.291666666, 4,2.666666666, 7.625,-.375
90, 7.625,0, 2.666666666,4, 2.291666666,-3.041666666

*RBBRICKS,RUNNING BOND BRICK - SIMPLE
0, 0,0, 0,2.666666666
90, 0,0, 2.666666666,4, 2.666666666,-2.666666666

*SACNCR, Concrete
45, 0,0, 0,.09375
45, .066291261,0, 0,.09375, 0,-.09375

*SBBRICKC,STACK BOND BRICK - COMPLEX
0, 0,0, 0,2.666666666, 7.625,-0.375
0, 0,2.291666666, 0,2.666666666, 7.625,-0.375
90, 0,0, 0,8, 2.291666666,-0.375
90, 7.625,0, 0,8, 2.291666666,-0.375

*SBBRICKS,STACK BOND BRICK - SIMPLEX
0, 0,0, 0,2.666666666
90, 0,0, 0,8

*SCREEN,WINDOW SCREEN
0.0000, 0.120,0.500, 1.000,1.000, 0.760000,-0.240
180.0000, 0.380,0.000, 1.000,1.000, 0.380000,-0.620
180.0000, 1.000,0.000, 1.000,1.000, 0.380000,-0.620
90.0000, 0.500,0.620, 1.000,1.000, 0.380000,-0.620
90.0000, 0.500,0.000, 1.000,1.000, 0.380000,-0.620
270.0000, 1.000,0.880, 1.000,1.000, 0.760000,-0.240

*SHAKES1,SHAKES - RANDOM COURSING
0, 0,.03, 1,1, 0.1,-.9
0, 0.100,0, 1,1, 0.3,-0.700
0, 0.40,0.02, 1,1, 0.15,-0.850
0, 0.55,0, 1,1, 0.3,-0.700
0, 0.85,.03, 1,1, 0.15,-0.850
0, 0.15,0.33, 1,1, 0.3,-0.700
0, 0,0.35, 1,1, 0.15,-0.850
0, 0.45,0.36, 1,1, 0.2,-0.800
0, 0.65,0.33, 1,1, 0.35,-0.650
0, 0,0.67, 1,1, 0.34,-0.660
0, 0.34,0.69, 1,1, 0.24,-0.760
0, 0.58,0.66, 1,1, 0.18,-0.820
0, 0.76,0.70, 1,1, 0.17,-0.830
180, 1,0.67, 1,1, 0.07,-0.930
90, 0.10,0, 1,1, 0.35,-0.650
90, 0.40,0, 1,1, 0.33,-0.670
90, 0.55,0, 1,1, 0.36,-0.640
90, 0.85,0, 1,1, 0.33,-0.670
90, 0.45,0.33, 1,1, 0.36,-0.640
90, 0.34,0.67, 1,1, 0.33,-0.670
90, 0.58,0.66, 1,1, 0.34,-0.660
270, 0,0.670, 1,1, 0.34,-0.660
270, 0.15,0.67, 1,1, 0.34,-0.660
270, 0.65,0.66, 1,1, 0.33,-0.670
90, 0.93,0.67, 1,1, 0.33,-0.670
90, 0.76,0.66, 1,1, 0.34,-0.660
270, 0.93,.03, 1,1, .0300,-0.970

*SHAKES2,SHAKES - REGULAR COURSING
0, 0.880,0, 1,1, 0.12,-0.880
180, 0.070,0, 1,1, 0.07,-0.930
90, 0.070,0, 1,1, 0.33,-0.670
90, 0.550,0, 1,1, 0.33,-0.670
180, 0.150,0.330, 1,1, 0.15,-0.850
270, 0.150,0.670, 1,1, 0.34,-0.660
90, 0.880,0, 1,1, 0.33,-0.670
270, 0.430,0.670, 1,1, 0.34,-0.660
270, 0.640,0.670, 1,1, 0.34,-0.660
90, 0.980,0.670, 1,1, 0.33,-0.670
90, 0.740,0.670, 1,1, 0.33,-0.670
90, 0.330,0.670, 1,1, 0.33,-0.670
90, 0.710,0.670, 1,1, 0.33,-0.670
0, 0.740,0.670, 1,1, 0.24,-0.760
90, 1,0.670, 1,1, 0.33,-0.670
0, 0.330,0.670, 1,1, 0.38,-0.620
90, 0.300,0.670, 1,1, 0.33,-0.670
0, 0,0.670, 1,1, 0.30,-0.700
0, 0.670,0.330, 1,1, 0.33,-0.670
270, 0.670,0.670, 1,1, 0.34,-0.660
0, 0.430,0.330, 1,1, 0.21,-0.790
90, 0.400,0.330, 1,1, 0.34,-0.660
0, 0.180,0.330, 1,1, 0.22,-0.780
270, 0.180,0.670, 1,1, 0.34,-0.660
90, 0.850,0, 1,1, 0.33,-0.670
0, 0.550,0, 1,1, 0.30,-0.700
90, 0.520,0, 1,1, 0.33,-0.670
0, 0.100,0, 1,1, 0.42,-0.580
90, 0.100,0, 1,1, 0.33,-0.670

*SHINGLE1,ROOF SINGLES
270, .05,1, 1,1, .5,-.5
0, .05,.5, 1,1, .95,-.05
270, .5,.5, 1,1, .5,-.5
180, .5,0, 1,1, .5,-.5
270, .55,.5, 1,1, .5,-.5
0, .55,0, 1,1, .45,-.55
90, 0,.5, 1,1, .5,-.5

*SPANTILE,SPANISH TILE
274.9697, 0.920,1.000, -12.041517,0.043315, 0.923472,-22.163321
180.0000, 1.000,0.080, 1.000,1.000, 0.080000,-0.920
0.0000, 0.000,0.000, 1.000,1.000, 0.280000,-0.720
90.0000, 0.280,0.000, 1.000,1.000, 0.100000,-0.900
270.0000, 0.920,0.100, 1.000,1.000, 0.100000,-0.900
0.0000, 0.920,0.000, 1.000,1.000, 0.080000,-0.920
0.0000, 0.000,0.080, 1.000,1.000, 0.200000,-0.800
85.0303, 0.200,0.080, 12.041517,0.043315, 0.923472,-22.163321
52.6961, 0.200,0.130, -21.400901,0.037878, 0.264008,-26.136750
18.4349, 0.360,0.340, 2.213594,0.316228, 0.252982,-2.909295
341.5651, 0.600,0.420, -2.213594,0.316228, 0.252982,-2.909295
307.3039, 0.840,0.340, 21.400901,0.037878, 0.264008,-26.136750
20.2249, 0.410,0.270, -11.704596,0.049386, 0.202485,-20.045972
339.7751, 0.600,0.340, 11.704596,0.049386, 0.202485,-20.045972
307.4054, 0.790,0.270, 16.401153,0.046727, 0.214009,-21.186925
52.5946, 0.280,0.100, -16.401153,0.046727, 0.214009,-21.186925

*SQDOTS,SQUARE DOTS (GRID) 
0, 0,0, 0,1, 0,-1

*STIPPLE,STIPPLE
0, 0.040,0.020, 0,1, 0,-1
0, 0.360,0.040, 0,1, 0,-1
0, 0.180,0.260, 0,1, 0,-1
0, 0.400,0.420, 0,1, 0,-1
0, 0.140,0.480, 0,1, 0,-1
0, 0.220,0.720, 0,1, 0,-1
0, 0.080,0.900, 0,1, 0,-1
0, 0.400,0.880, 0,1, 0,-1
0, 0.640,0.920, 0,1, 0,-1
0, 0.760,0.680, 0,1, 0,-1
0, 0.960,0.660, 0,1, 0,-1
0, 0.960,0.300, 0,1, 0,-1
0, 0.780,0.180, 0,1, 0,-1
0, 0.500,0.240, 0,1, 0,-1
0, 0.680,0.420, 0,1, 0,-1
0, 0.500,0.600, 0,1, 0,-1
0, 0.920,0.040, 0,1, 0,-1

*SQUARE,Small aligned squares
0, 0,0, 0,.125, .125,-.125
90, 0,0, 0,.125, .125,-.125
*STARS, Star of David
0, 0,0, 0,.216506351, .125,-.125
60, 0,0, 0,.216506351, .125,-.125
120, .0625,.108253176, 0,.216506351, .125,-.125
*STEEL, Steel material
45, 0,0, 0,.125
45, 0,.0625, 0,.125

*SUPERDCR,SUPERDECOR CONC PAVERS
45, 7.174,3.808, 0,6.010, 1.250,-4.760
45, 3.808,7.174, 0,6.010, 1.250,-4.760
135, 4.692,3.808, 0,6.010, 1.250,-4.760
135, 8.058,7.174, 0,6.010, 1.250,-4.760
45, 3.366,3.366, 0,6.010, 1.250,-4.760
135, 8.500,3.366, 0,6.010, 1.250,-4.760
0, 4.692,3.808, 0,4.250, 2.482,-1.768
90, 3.808,4.692, 0,4.250, 2.482,-1.768

*SWAMP, Swampy area
0, 0,0, .5,.866025403, .125,-.875
90, .0625,0, .866025403,.5, .0625,-1.669550806
90, .078125,0, .866025403,.5, .05,-1.682050806
90, .046875,0, .866025403,.5, .05,-1.682050806
60, .09375,0, .5,.866025403, .04,-.96
120, .03125,0, .5,.866025403, .04,-.96

*TES36,TRIPLE HEXES
30, 0,0, .1875,.3247595264192, .125,-.25
150, 0,0, .1875,.3247595264192, .125,-.25
270, 0,0, .1875,.3247595264192, .125,-.25
30, .2165063509461,0, .1875,.3247595264192, .125,-.25
150, .2165063509461,0, .1875,.3247595264192, .125,-.25
270, .2165063509461,0, .1875,.3247595264192, .125,-.25

*TRANS, Heat transfer material
0, 0,0, 0,.25
0, 0,.125, 0,.25, .125,-.125
*TRIANG, Equilateral triangles
60, 0,0, .1875,.324759526, .1875,-.1875
120, 0,0, .1875,.324759526, .1875,-.1875
0, -.09375,.162379763, .1875,.324759526, .1875,-.1875

*THREAD,ANCHOR BOLT THREAD BY VISIO CORPORATION
0, 0,0, 0,.5
0, .3333,.25, 0,.5, .333,-.666

*TRIDOTS, TRIDOTS (ANGLED GRID)
0, 0,0, .5,.866025404, 0,-1

*TURFSTNE,TURF-STONE HATCH PATTERN
0, 2.5,0, 0,24, 3,-5
90, 0,2.5, 0,16, 3,-5
45, 5.5,0, 0,5.6599, 3.5355,-2.1213
45, 4,1.5, 0,5.6599, 3.5355,-2.1213
135, 10.5,0, 0,-5.6599, 3.5355,-2.1213
135, 4,1.5, 0,-5.6599, 3.5355,-2.1213

*UNIDECOR,UNIDECOR CONC. PAVERS
0, 1,0, 9,9, 3.5,-5.5
45, 4.5,0, 6.364,6.364, 1.414,-4.950
90, 5.5,1, 9,9, 3.5,-5.5
135, 5.5,4.5, 6.364,6.364, 1.414,-4.950
180, 4.5,5.5, 9,9, 3.5,-5.5
270, 0,4.5, 9,9, 3.5,-5.5
90, 1,5.5, 9,9, 3.5,-5.5
90, 4.5,5.5, 9,9, 3.5,-5.5
0, 5.5,1, 9,9, 3.5,-5.5
0, 5.5,4.5, 9,9, 3.5,-5.5

*UNIHER,UNISTONE HERRINGBONE PATTERN
18.435, 0,0, 5,2.5, 1.25,-10,2.5,-11.25
18.435, 2.76699,-.39528, 5,2.5, 2.5,-10,1.25,-11.25
108.435, .39528,-1.18585, 2.5,-5, 2.5,-10,2.5,-10
108.435, .39528,2.76699, 2.5,-5, 2.5,-10,2.5,-10
108.435, 3.95284,0, 2.5,-5, 1.25,-11.25
108.435, -3.55757,2.76699, 2.5,-5, 1.25,-11.25
333.435, 1.185854,.395286, 1.76777,5.3033, 1.76777,-15.909903,1.76777,-15.909903
333.435, -6.719844,4.348126,  1.76777,5.3033, 1.767767,-33.587572
333.435, 5.1387,.395289, 1.76777,5.3033, 1.76777,-7.0771068,1.76777,-24.748737
333.435, -2.766997,4.348129, 1.76777,5.3033, 1.767767,-33.587572
333.435, 9.09155,.39529, 1.76777,5.3033, 1.76777,-15.909903,1.76777,-15.909903
333.435, 16.997246,-3.557547, 1.76777,5.3033, 1.767767,-33.587572
63.435, -.3953,1.1859, -5.3033,1.7678, 1.7678,-7.071,1.7678,-15.91,1.7678,-7.071

*UNIPARQ,UNISTONE PARQUET PATTERN
18.435, -1.18585377,-.39528577, 10,5, 2.5,-10
18.435, 7.90569062,3.95285414, 10,5, 1.25,-10,2.5,-11.25
18.435, -1.1858573,3.55756131, 10,5, 1.25,-11.25,2.5,-10
18.435, 14.62552747,7.51042251, 10,5, 2.5,-22.5
63.435, -.39528577,1.18585377, 24.74873734,3.53553391, 1.76776695,-15.90990258
63.435, -.39528577,5.13870084, 24.74873734,3.53553391, 1.76776695,-15.90990258
63.435, 3.55756131,1.1858573, 24.74873734,3.53553391, 1.76776695,-33.58757211
63.435, 3.55755778,5.13870438, 24.74873734,3.53553391, 1.76776695,-33.58757211
108.435, .39528577,-1.18585377, 10,5, 2.5,-10
108.435, .39528224,2.76699331, 10,5, 2.5,-10,1.25,-11.25
108.435, .39527871,6.71984038, 10,5, 2.5,-22.5
108.435, 3.95284708,.00000353, 10,5, 1.25,-10,2.5,-11.25
153.435, -1.18585377,-.39528577, 24.74873734,3.53553391, 1.76776695,-33.58757211
153.435, -1.18585730,3.55756131, 24.74873734,3.53553391, 1.76776695,-33.58757211
153.435, -5.13870084,-.39528930, 24.74873734,3.53553391, 1.76776695,-33.58757211
153.435, -5.13870438,3.55755778, 24.74873734,3.53553391, 1.76776695,-33.58757211
153.435, -5.13870791,7.51040485, 24.74873734,3.53553391, 1.76776695,-33.58757211
153.435, -1.18586083,7.51040838, 24.74873734,3.53553391, 1.76776695,-33.58757211

*UNIRN,UNI-STONE RUNNER PAVING STONE PATTERN
18.4350, -1.18585377,-.39528577, 8.75,1.25, 2.5,-10
108.4350, .39528577,-1.18585377, 21.25,1.25, 2.5,-22.5
63.4350, -.39528929,5.13870085, 3.53553391,1.76776695, 1.76776695,-15.90990258
333.4350, -2.76699331,.39528224, 3.53553391,1.76776695, 1.76776695,-7.07106781

*WAFFLE,WAFFLE SYSTEM PLAN VIEW BY VISIO CORPORATION
0, .7,.5, 0,1.2, 1,-.2
0, .7,.7, 0,1.2, 1,-.2
90, .5,.7, 0,1.2, 1,-.2
90, .7,.7, 0,1.2, 1,-.2

*WATER,WATER
0, 0,0, 0,1, .2,-.8
45, .4,.1, .7071067812,.7071067812, .2828427125,-1.13137085
135, .8,.1, .7071067812,.7071067812, .2828427125,-1.13137085
26.5650512, .2,0, .894427191,-.447213595, .2236,-2.012467977
333.4349488, .8,.1, .894427191,.447213595, .2236,-2.012467977

*WOOD1,WOOD GRAIN
216.8699, 0.400,1.000, -3.600000,0.200000, 0.500000,-4.500000
206.5651, 1.000,0.700, 1.341641,0.447214, 1.118034,-1.118034
198.4349, 1.000,0.200, 2.213594,0.316228, 0.632456,-2.529822

*WOOD2,SIMPLE WOOD GRAIN
108.4349, 0.260,0.000, 2.213594,0.316228, 0.379473,-2.782804
139.3987, 0.140,0.360, 7.809496,0.108465, 0.184391,-9.035154
136.8476, 1.000,0.480, 20.518234,0.045596, 0.438634,-21.493078
109.9831, 0.680,0.780, 8.543577,0.085436, 0.234094,-11.470606
90.0000, 0.600,0.000, 1.000,1.000, 0.200000,-0.800
118.4429, 0.600,0.200, -14.764778,0.036637, 0.545894,-26.748794
84.2894, 0.340,0.680, -9.054838,0.099504, 0.200998,-9.848878
129.8056, 0.360,0.880, -6.401844,0.128037, 0.156205,-7.654045

*WOOD3,THIRD WOOD PATTERN
355.2364, 0.000,0.170, -11.045049,0.083045, 0.120416,-11.921179
11.3099, 0.120,0.160, 4.118439,0.196116, 0.152971,-4.946049
45.0000, 0.270,0.190, 0.707107,0.707107, 0.113137,-1.301076
46.8476, 0.350,0.270, 20.518234,0.045596, 0.219317,-21.712395
12.9946, 0.500,0.430, -9.219240,0.074953, 0.133417,-13.208247
0.0000, 0.630,0.460, 1.000,1.000, 0.250000,-0.750
350.5377, 0.880,0.460, -5.096369,0.164399, 0.121655,-5.961107
354.2894, 0.000,0.440, -9.054838,0.099504, 0.100499,-9.949377
0.0000, 0.100,0.430, 1.000,1.000, 0.150000,-0.850
28.3008, 0.250,0.430, 12.529781,0.067729, 0.147648,-14.617175
52.1250, 0.380,0.500, -6.402524,0.087706, 0.228035,-11.173719
39.2894, 0.520,0.680, 7.809933,0.070360, 0.142127,-14.070544
6.3402, 0.630,0.770, 8.061501,0.110432, 0.181108,-8.874277
348.1113, 0.810,0.790, -14.317728,0.051503, 0.194165,-19.222323
353.2902, 0.000,0.750, 9.055197,0.058421, 0.171172,-16.946070
3.3665, 0.170,0.730, 16.031112,0.058722, 0.170294,-16.859093
33.6901, 0.340,0.740, -2.218801,0.277350, 0.180278,-3.425274
47.4896, 0.490,0.840, 14.865942,0.061430, 0.162788,-16.116032
14.9314, 0.600,0.960, 11.401572,0.064416, 0.155242,-15.368933
0.0000, 0.750,1.000, 1.000,1.000, 0.120000,-0.880
347.0054, 0.870,1.000, 9.219240,0.074953, 0.133417,-13.208247
0.0000, 0.310,0.000, 1.000,1.000, 0.000000,-1.000
223.1524, 0.450,0.150, -20.518234,0.045596, 0.219317,-21.712395
206.5651, 0.290,1.000, 1.341641,0.447214, 0.089443,-2.146625
188.1301, 0.210,0.960, 6.081118,0.141421, 0.141421,-6.929646
156.8014, 0.070,0.940, 5.383564,0.131306, 0.076158,-7.539615
26.5651, 0.450,0.150, 1.341641,0.447214, 0.111803,-2.124265
6.7098, 0.550,0.200, -9.055197,0.058421, 0.171172,-16.946070
349.8753, 0.720,0.220, 17.262641,0.035158, 0.284429,-28.158496
349.6952, 0.000,0.060, 6.082105,0.089443, 0.111803,-11.068536
15.5241, 0.110,0.040, -11.401629,0.053529, 0.186815,-18.494726
42.8789, 0.290,0.090, -17.691729,0.052342, 0.191050,-18.913923
34.6952, 0.430,0.220, 12.206392,0.063246, 0.158114,-15.653274
9.4623, 0.560,0.310, 5.096369,0.164399, 0.182483,-5.900280
353.4181, 0.740,0.340, -17.117200,0.038208, 0.261725,-25.910780
351.8699, 0.000,0.310, -6.081118,0.141421, 0.141421,-6.929646
11.3099, 0.140,0.290, 4.118439,0.196116, 0.152971,-4.946049
42.5104, 0.290,0.320, -14.865942,0.061430, 0.162788,-16.116032
45.0000, 0.410,0.430, 0.707107,0.707107, 0.183848,-1.230366
17.3540, 0.540,0.560, -13.601340,0.059655, 0.167631,-16.595424
356.6335, 0.700,0.610, -16.031112,0.058722, 0.170294,-16.859093
342.8973, 0.870,0.600, 10.440048,0.073521, 0.136015,-13.465456
351.2538, 0.000,0.560, 7.070659,0.076029, 0.131529,-13.021417
14.9314, 0.130,0.540, 11.401572,0.064416, 0.155242,-15.368933
32.0054, 0.280,0.580, -5.829988,0.106000, 0.188680,-9.245302
49.8991, 0.440,0.680, -17.029339,0.040258, 0.248395,-24.591090
15.9454, 0.600,0.870, -4.120817,0.137361, 0.145602,-7.134508
353.9910, 0.740,0.910, 10.049739,0.052342, 0.191050,-18.913923
336.8014, 0.930,0.890, 5.383564,0.131306, 0.076158,-7.539615
350.5377, 0.000,0.860, -5.096369,0.164399, 0.121655,-5.961107
10.0080, 0.120,0.840, 11.180190,0.057928, 0.172627,-17.090050
37.4054, 0.290,0.870, 16.401153,0.046727, 0.214009,-21.186925
29.0546, 0.460,0.000, 8.061673,0.097129, 0.102956,-10.192674
10.7843, 0.550,0.050, -16.278753,0.046778, 0.213776,-21.163783
352.8750, 0.760,0.090, -7.069980,0.124035, 0.241868,-7.820390

*WOOD4,NEW WOOD PATTERN
6.8428, 0.000,0.000, -17.117197,0.039715, 0.251794,-24.927563
26.5651, 0.250,0.030, 1.341641,0.447214, 0.111803,-2.124265
48.8141, 0.350,0.080, 9.219065,0.094072, 0.106301,-10.523844
67.3801, 0.420,0.160, -7.615385,0.076923, 0.130000,-12.870000
90.0000, 0.470,0.280, 1.000,1.000, 0.160000,-0.840
61.3895, 0.470,0.440, -10.295321,0.079809, 0.125300,-12.404664
86.1859, 0.530,0.550, -14.035511,0.066519, 0.150333,-14.882963
72.8973, 0.540,0.700, 10.440048,0.073521, 0.136015,-13.465456
41.9872, 0.580,0.830, -12.041365,0.074329, 0.134536,-13.319088
10.3048, 0.680,0.920, -6.082105,0.089443, 0.111803,-11.068536
15.9454, 0.790,0.940, -4.120817,0.137361, 0.218403,-7.061707
6.8428, 0.200,0.000, -17.117197,0.039715, 0.251794,-24.927563
26.5651, 0.450,0.030, 1.341641,0.447214, 0.111803,-2.124265
48.8141, 0.550,0.080, 9.219065,0.094072, 0.106301,-10.523844
67.3801, 0.620,0.160, -7.615385,0.076923, 0.130000,-12.870000
90.0000, 0.670,0.280, 1.000,1.000, 0.160000,-0.840
61.3895, 0.670,0.440, -10.295321,0.079809, 0.125300,-12.404664
86.1859, 0.730,0.550, -14.035511,0.066519, 0.150333,-14.882963
72.8973, 0.740,0.700, 10.440048,0.073521, 0.136015,-13.465456
41.9872, 0.780,0.830, -12.041365,0.074329, 0.134536,-13.319088
10.3048, 0.880,0.920, -6.082105,0.089443, 0.111803,-11.068536
15.9454, 0.990,0.940, -4.120817,0.137361, 0.218403,-7.061707
6.8428, 0.400,0.000, -17.117197,0.039715, 0.251794,-24.927563
26.5651, 0.650,0.030, 1.341641,0.447214, 0.111803,-2.124265
48.8141, 0.750,0.080, 9.219065,0.094072, 0.106301,-10.523844
67.3801, 0.820,0.160, -7.615385,0.076923, 0.130000,-12.870000
90.0000, 0.870,0.280, 1.000,1.000, 0.160000,-0.840
61.3895, 0.870,0.440, -10.295321,0.079809, 0.125300,-12.404664
86.1859, 0.930,0.550, -14.035511,0.066519, 0.150333,-14.882963
72.8973, 0.940,0.700, 10.440048,0.073521, 0.136015,-13.465456
41.9872, 0.980,0.830, -12.041365,0.074329, 0.134536,-13.319088
10.3048, 1.080,0.920, -6.082105,0.089443, 0.111803,-11.068536
15.9454, 1.190,0.940, -4.120817,0.137361, 0.218403,-7.061707
6.8428, 0.600,0.000, -17.117197,0.039715, 0.251794,-24.927563
26.5651, 0.850,0.030, 1.341641,0.447214, 0.111803,-2.124265
48.8141, 0.950,0.080, 9.219065,0.094072, 0.106301,-10.523844
67.3801, 1.020,0.160, -7.615385,0.076923, 0.130000,-12.870000
90.0000, 1.070,0.280, 1.000,1.000, 0.160000,-0.840
61.3895, 1.070,0.440, -10.295321,0.079809, 0.125300,-12.404664
86.1859, 1.130,0.550, -14.035511,0.066519, 0.150333,-14.882963
72.8973, 1.140,0.700, 10.440048,0.073521, 0.136015,-13.465456
41.9872, 1.180,0.830, -12.041365,0.074329, 0.134536,-13.319088
10.3048, 1.280,0.920, -6.082105,0.089443, 0.111803,-11.068536
15.9454, 1.390,0.940, -4.120817,0.137361, 0.218403,-7.061707
6.8428, 0.800,0.000, -17.117197,0.039715, 0.251794,-24.927563
26.5651, 1.050,0.030, 1.341641,0.447214, 0.111803,-2.124265
48.8141, 1.150,0.080, 9.219065,0.094072, 0.106301,-10.523844
67.3801, 1.220,0.160, -7.615385,0.076923, 0.130000,-12.870000
90.0000, 1.270,0.280, 1.000,1.000, 0.160000,-0.840
61.3895, 1.270,0.440, -10.295321,0.079809, 0.125300,-12.404664
86.1859, 1.330,0.550, -14.035511,0.066519, 0.150333,-14.882963
72.8973, 1.340,0.700, 10.440048,0.073521, 0.136015,-13.465456
41.9872, 1.380,0.830, -12.041365,0.074329, 0.134536,-13.319088
10.3048, 1.480,0.920, -6.082105,0.089443, 0.111803,-11.068536
15.9454, 1.590,0.940, -4.120817,0.137361, 0.218403,-7.061707

*WOOD8,CURVY WOOD
349.6952, 0.310,0.770, 6.082105,0.089443, 0.111803,-11.068536
0.0000, 0.420,0.750, 1.000,1.000, 0.110000,-0.890
18.4349, 0.530,0.750, 2.213594,0.316228, 0.094868,-3.067409
172.8750, 0.620,0.780, -7.069980,0.124035, 0.080623,-7.981635
174.8056, 0.540,0.790, -10.049468,0.090536, 0.110454,-10.934907
194.0362, 0.430,0.800, 3.152963,0.242536, 0.123693,-3.999412
9.4623, 0.390,0.770, 5.096369,0.164399, 0.060828,-6.021935
353.6598, 0.450,0.780, -8.061501,0.110432, 0.090554,-8.964831
185.7106, 0.540,0.770, 9.054838,0.099504, 0.100499,-9.949377
168.6901, 0.440,0.760, -4.118439,0.196116, 0.050990,-5.048029
354.8056, 0.220,0.760, -10.049468,0.090536, 0.110454,-10.934907
348.6901, 0.330,0.750, -4.118439,0.196116, 0.101980,-4.997039
0.0000, 0.430,0.730, 1.000,1.000, 0.120000,-0.880
20.5560, 0.550,0.730, 5.383893,0.117041, 0.085440,-8.458564
3.8141, 0.630,0.760, 14.035511,0.066519, 0.150333,-14.882963
354.8056, 0.780,0.770, -10.049468,0.090536, 0.110454,-10.934907
0.0000, 0.890,0.760, 1.000,1.000, 0.110000,-0.890
5.1944, 0.000,0.760, 10.049468,0.090536, 0.110454,-10.934907
354.8056, 0.110,0.770, -10.049468,0.090536, 0.110454,-10.934907
0.0000, 0.000,0.780, 1.000,1.000, 0.060000,-0.940
5.1944, 0.060,0.780, 10.049468,0.090536, 0.110454,-10.934907
0.0000, 0.170,0.790, 1.000,1.000, 0.100000,-0.900
10.3048, 0.270,0.790, -6.082105,0.089443, 0.111803,-11.068536
5.1944, 0.380,0.810, 10.049468,0.090536, 0.110454,-10.934907
354.8056, 0.490,0.820, -10.049468,0.090536, 0.110454,-10.934907
354.8056, 0.600,0.810, -10.049468,0.090536, 0.110454,-10.934907
351.8699, 0.710,0.800, -6.081118,0.141421, 0.141421,-6.929646
0.0000, 0.850,0.780, 1.000,1.000, 0.150000,-0.850
347.4712, 0.810,0.180, 5.097866,0.108465, 0.092195,-9.127349
354.2894, 0.900,0.160, -9.054838,0.099504, 0.100499,-9.949377
8.1301, 0.810,0.180, 6.081118,0.141421, 0.070711,-7.000357
9.4623, 0.880,0.190, 5.096369,0.164399, 0.121655,-5.961107
0.0000, 0.000,0.210, 1.000,1.000, 0.120000,-0.880
350.5377, 0.120,0.210, -5.096369,0.164399, 0.060828,-6.021935
201.8014, 0.180,0.200, -3.156821,0.185695, 0.053852,-5.331313
192.9946, 0.130,0.180, -9.219240,0.074953, 0.133417,-13.208247
352.8750, 0.920,0.180, -7.069980,0.124035, 0.080623,-7.981635
7.1250, 0.920,0.180, 7.069980,0.124035, 0.080623,-7.981635
0.0000, 0.000,0.190, 1.000,1.000, 0.080000,-0.920
194.0362, 0.080,0.190, 3.152963,0.242536, 0.082462,-4.040644
356.6335, 0.220,0.220, -16.031112,0.058722, 0.170294,-16.859093
357.7094, 0.390,0.210, -24.020791,0.039968, 0.250200,-24.769792
3.1798, 0.640,0.200, 17.029296,0.055470, 0.180278,-17.847479
9.4623, 0.820,0.210, 5.096369,0.164399, 0.182483,-5.900280
10.3048, 0.000,0.120, -6.082105,0.089443, 0.111803,-11.068536
15.9454, 0.110,0.140, -4.120817,0.137361, 0.145602,-7.134508
0.0000, 0.250,0.180, 1.000,1.000, 0.130000,-0.870
351.8699, 0.380,0.180, -6.081118,0.141421, 0.141421,-6.929646
3.5763, 0.520,0.160, 15.033167,0.062378, 0.160312,-15.870907
351.2538, 0.680,0.170, 7.070659,0.076029, 0.131529,-13.021417
345.9638, 0.810,0.150, -3.152963,0.242536, 0.123693,-3.999412
0.0000, 0.930,0.120, 1.000,1.000, 0.070000,-0.930
174.8056, 0.220,0.220, -10.049468,0.090536, 0.220907,-10.824454
355.2364, 0.000,0.280, -11.045049,0.083045, 0.240832,-11.800763
0.0000, 0.240,0.260, 1.000,1.000, 0.230000,-0.770
4.0856, 0.470,0.260, 13.038210,0.071247, 0.280713,-13.754955
0.0000, 0.750,0.280, 1.000,1.000, 0.250000,-0.750
7.1250, 0.000,0.070, 7.069980,0.124035, 0.241868,-7.820390
6.3402, 0.240,0.100, 8.061501,0.110432, 0.181108,-8.874277
357.5104, 0.420,0.120, -22.022673,0.043437, 0.230217,-22.791512
353.4802, 0.650,0.110, -26.172489,0.028387, 0.352278,-34.875552
3.0128, 0.000,0.720, 18.027680,0.052559, 0.190263,-18.836035
351.8699, 0.190,0.730, -6.081118,0.141421, 0.212132,-6.858936
357.6141, 0.400,0.700, -23.021691,0.041631, 0.240208,-23.780616
10.6197, 0.640,0.690, -11.180171,0.061430, 0.162788,-16.116032
0.0000, 0.800,0.720, 1.000,1.000, 0.200000,-0.800
356.8202, 0.000,0.840, -17.029296,0.055470, 0.180278,-17.847479
6.0090, 0.180,0.830, -10.049739,0.052342, 0.191050,-18.913923
6.7098, 0.370,0.850, -9.055197,0.058421, 0.171172,-16.946070
354.2894, 0.540,0.870, -9.054838,0.099504, 0.200998,-9.848878
347.9052, 0.740,0.850, -9.219280,0.069843, 0.143178,-14.174643
9.4623, 0.880,0.820, 5.096369,0.164399, 0.121655,-5.961107
3.8141, 0.000,0.650, 14.035511,0.066519, 0.150333,-14.882963
347.1957, 0.150,0.660, -13.341590,0.044324, 0.225610,-22.335418
0.0000, 0.370,0.610, 1.000,1.000, 0.250000,-0.750
5.4403, 0.620,0.610, -11.045259,0.047405, 0.210950,-20.884073
6.7098, 0.830,0.630, -9.055197,0.058421, 0.171172,-16.946070
0.0000, 0.000,0.910, 1.000,1.000, 0.170000,-0.830
8.1301, 0.170,0.910, 6.081118,0.141421, 0.282843,-6.788225
357.6141, 0.450,0.950, -23.021691,0.041631, 0.240208,-23.780616
354.4725, 0.690,0.940, 21.094999,0.032108, 0.311448,-30.833375
6.8428, 0.000,0.000, -17.117197,0.039715, 0.251794,-24.927563
0.0000, 0.250,0.030, 1.000,1.000, 0.280000,-0.720
356.3478, 0.530,0.030, -31.064442,0.021233, 0.470956,-46.624691
0.0000, 0.000,0.350, 1.000,1.000, 0.240000,-0.760
4.7636, 0.240,0.350, 11.045049,0.083045, 0.240832,-11.800763
358.1524, 0.480,0.370, -30.016645,0.032241, 0.310161,-30.705964
357.2737, 0.790,0.360, -20.024928,0.047565, 0.210238,-20.813558
354.8056, 0.000,0.510, -10.049468,0.090536, 0.220907,-10.824454
0.0000, 0.220,0.490, 1.000,1.000, 0.320000,-0.680
1.9092, 0.540,0.490, 29.017217,0.033315, 0.300167,-29.716495
3.5763, 0.840,0.500, 15.033167,0.062378, 0.160312,-15.870907

*ZIGZAG, Staircase effect
0, 0,0, .125,.125, .125,-.125
90, .125,0, .125,.125, .125,-.125

